<?php

namespace App\Filament\Exports;

use App\Models\CashMovement;
use Filament\Actions\Exports\ExportColumn;
use Filament\Actions\Exports\Exporter;
use Filament\Actions\Exports\Models\Export;


class CashMovementExporter extends Exporter
{
    protected static ?string $model = CashMovement::class;

    public static function getColumns(): array
    {
        return [
            ExportColumn::make('reference_type')
                ->label('Origen')
                ->state(
                    fn(CashMovement $record): string => $record->reference
                        ? match ($record->reference_type) {
                            'App\Models\Appointment' => 'Cita del paciente: ' . $record->reference->patient->full_name,
                            default => class_basename($record->reference_type) . ' #' . $record->reference->id,
                        }
                        : 'Sin origen'
                ),

            ExportColumn::make('user.full_name')->label('Usuario'),
            ExportColumn::make('type')->label('Tipo'),
            ExportColumn::make('method')->label('Método'),
            ExportColumn::make('amount')->label('Monto'),
            ExportColumn::make('created_at')->label('Fecha'),
        ];
    }

    public static function getCompletedNotificationBody(Export $export): string
    {
        $body = 'Your cash movement export has completed and ' . number_format($export->successful_rows) . ' ' . str('row')->plural($export->successful_rows) . ' exported.';

        if ($failedRowsCount = $export->getFailedRowsCount()) {
            $body .= ' ' . number_format($failedRowsCount) . ' ' . str('row')->plural($failedRowsCount) . ' failed to export.';
        }

        return $body;
    }
}
