<?php

namespace App\Filament\Exports;

use App\Models\Appointment;
use Filament\Actions\Exports\ExportColumn;
use Filament\Actions\Exports\Exporter;
use Filament\Actions\Exports\Models\Export;

class CommissionExporter extends Exporter
{
    protected static ?string $model = Appointment::class;

    public static function getColumns(): array
    {
        return [
            ExportColumn::make('patient.full_name')
                ->label('Paciente')
                ->state(fn(Appointment $record): string => $record->patient->full_name),

            ExportColumn::make('user.full_name')
                ->label('Usuario'),

            ExportColumn::make('doctor.full_name')
                ->label('Medic@'),

            ExportColumn::make('total_cost')
                ->label('Costo total'),
            ExportColumn::make('status')
                ->label('Estado'),

            ExportColumn::make('appointment_date')
                ->label('Fecha de cita'),
        ];
    }

    public static function getCompletedNotificationBody(Export $export): string
    {
        $body = 'Your commission export has completed and ' . number_format($export->successful_rows) . ' ' . str('row')->plural($export->successful_rows) . ' exported.';

        if ($failedRowsCount = $export->getFailedRowsCount()) {
            $body .= ' ' . number_format($failedRowsCount) . ' ' . str('row')->plural($failedRowsCount) . ' failed to export.';
        }

        return $body;
    }
}
