<?php

namespace App\Filament\Pages;

use Filament\Pages\Page;
use App\Models\Inventory;
use Filament\Tables;
use Filament\Tables\Columns\TextColumn;
use Illuminate\Database\Eloquent\Builder;
use Filament\Tables\Filters\Filter;
use Filament\Forms\Components\DatePicker;

class Inventories extends Page implements Tables\Contracts\HasTable
{
    use Tables\Concerns\InteractsWithTable;

    protected static ?string $navigationIcon = 'heroicon-o-document-text';

    protected static string $view = 'filament.pages.inventories';
    protected static ?string $navigationGroup = 'Inventario';
    protected static ?int $navigationSort = 3;
    protected static ?string $title = 'Stock de productos';
    protected static ?string $navigationLabel = 'Stock de productos';

    protected function getTableQuery(): Builder
    {
        return Inventory::query()
            ->with('purchaseProduct', 'purchaseProduct.productPresentation', 'purchaseProduct.productPresentation.product')
            ->latest();
    }

    protected function getTableColumns(): array
    {
        return [
            TextColumn::make('purchaseProduct.productPresentation.product.name')
                ->label('Producto')
                ->searchable(),
            TextColumn::make('purchaseProduct.productPresentation.label')
                ->label('Presentación')
                ->searchable(),
            TextColumn::make('purchaseProduct.expiration_date')
                ->label('Fecha de vencimiento')
                ->date()
                ->sortable()
                ->searchable(),
            TextColumn::make('quantity')
                ->label('Total en stock')
                ->numeric()
                ->suffix(fn($record) => $record->purchaseProduct?->productPresentation?->unit ?? '')
                ->sortable(),
            TextColumn::make('status')
                ->label('Estado')
                ->sortable()
                ->badge()
                ->color(fn(string $state) => match ($state) {
                    'disponible' => 'success',
                    'vencido' => 'danger',
                    'proximo_a_vencer' => 'warning',
                    'agotado' => 'secondary',
                    default => 'primary',
                }),
        ];
    }

    public static function shouldRegisterNavigation(): bool
    {
        return auth()->user()->hasRole('Administrador');
    }

    public static function canAccess(): bool
    {
        return auth()->user()->hasRole('Administrador');
    }
}
