<?php

namespace App\Filament\Pages;

use Filament\Pages\Page;

class Statistics extends Page
{
    protected static ?string $navigationIcon = 'heroicon-o-document-text';
    protected static ?string $navigationGroup = 'Reportes';
    protected static ?string $title = 'Estadísticas';
    protected static ?string $navigationLabel = 'Estadísticas';

    protected static string $view = 'filament.pages.statistics';
    protected static bool $shouldRegisterNavigation = false;

    protected function getHeaderWidgets(): array
    {
        return [
            \App\Filament\Widgets\StatsOverview::class,
            \App\Filament\Widgets\AppointmentChart::class,
        ];
    }

    public static function shouldRegisterNavigation(): bool
    {
        return auth()->user()->hasRole('Administrador');
    }

    public static function canAccess(): bool
    {
        return auth()->user()->hasRole('Administrador');
    }
}
