<?php

namespace App\Filament\Resources\AppointmentResource\Pages;

use App\Filament\Resources\AppointmentResource;
use Filament\Actions;
use App\Models\Appointment;
use App\Models\Test;
use App\Models\TestPrice;
use App\Models\AppointmentTest;
use App\Models\ProfileTest;
use Filament\Resources\Pages\CreateRecord;


class CreateAppointment extends CreateRecord
{
    protected static string $resource = AppointmentResource::class;
    protected function mutateFormDataBeforeCreate(array $data): array
    {
        $data['user_id'] = auth()->id();
        $data['balance_due'] = $data['total_cost'] - $data['paid_amount'];
        return $data;
    }

    protected function afterCreate(): void
    {
        $appointment = $this->record;

        $selectedTestIds = $this->data['selected_test_ids'] ?? [];

        $priceType = $this->data['price_type'] ?? 'particular';
        $method = $this->data['method'];

        foreach ($selectedTestIds as $testId) {
            $test = Test::find($testId);

            if (!$test) continue;

            $price = TestPrice::where('test_id', $test->id)
                ->where('name', $priceType)
                ->value('price') ?? 0;

            // Guardamos el test o perfil principal
            $appointmentTest = AppointmentTest::create([
                'appointment_id' => $appointment->id,
                'test_id' => $test->id,
                'parent_id' => null,
                'price' => $price,
            ]);

            // Si es perfil, agregamos hijos
            if ($test->is_profile) {
                $children = ProfileTest::where('profile_id', $test->id)->get();

                foreach ($children as $child) {
                    $childPrice = TestPrice::where('test_id', $child->test_id)
                        ->where('name', $priceType)
                        ->value('price') ?? 0;

                    AppointmentTest::create([
                        'appointment_id' => $appointment->id,
                        'test_id' => $child->test_id,
                        'parent_id' => $appointmentTest->id,
                        'price' => $childPrice,
                    ]);
                }
            }
        }
        //Agregamos el pago inicial
        $openCashRegister = \App\Models\CashRegister::where('user_id', auth()->id())
            ->where('status', 'abierto')
            ->latest('opened_at')
            ->first();

        if ($openCashRegister && $appointment->paid_amount>0) {
            \App\Models\CashMovement::create([
                'cash_register_id' => $openCashRegister->id,
                'user_id' => auth()->id(),
                'type' => 'ingreso',
                'method' => $method,
                'amount' => $appointment->paid_amount,
                'reference_id' => $appointment->id,
                'reference_type' => \App\Models\Appointment::class,
            ]);
        }
    }
}
