<?php

namespace App\Filament\Resources\AppointmentResource\Pages;

use App\Filament\Resources\AppointmentResource;
use Filament\Actions;
use App\Models\AppointmentTest;
use App\Models\Test;
use App\Models\TestPrice;
use Filament\Resources\Pages\EditRecord;
use Illuminate\Database\Eloquent\Model;


class EditAppointment extends EditRecord
{
    protected static string $resource = AppointmentResource::class;

    protected function getHeaderActions(): array
    {
        return [
            Actions\DeleteAction::make(),
        ];
    }


    protected function handleRecordUpdate(Model $record, array $data): Model
    {
        $data['balance_due'] = $data['total_cost'] - ($record->paid_amount ?? 0);
        $record->update($data);
        return $record;
        return $record;
    }
   /* protected function afterSave(): void
    {
        $appointment = $this->record;

        $selectedTestIds = $this->data['selected_test_ids'] ?? [];

        $priceType = $this->data['price_type'] ?? 'particular';

        // Limpiar los appointment_tests actuales
        $appointment->appointmentTests()->delete();

        foreach ($selectedTestIds as $testId) {
            $test = Test::find($testId);

            if (!$test) continue;

            $price = TestPrice::where('test_id', $test->id)
                ->where('name', $priceType)
                ->value('price') ?? 0;

            // Guardamos el test principal
            $appointmentTest = AppointmentTest::create([
                'appointment_id' => $appointment->id,
                'test_id' => $test->id,
                'parent_id' => null,
                'price' => $price,
            ]);

            // Si es perfil, agregamos hijos
            if ($test->is_profile) {
                $children = Test::where('profile_id', $test->id)->get();

                foreach ($children as $child) {
                    $childPrice = TestPrice::where('test_id', $child->id)
                        ->where('name', $priceType)
                        ->value('price') ?? 0;

                    AppointmentTest::create([
                        'appointment_id' => $appointment->id,
                        'test_id' => $child->id,
                        'parent_id' => $test->id,
                        'price' => $childPrice,
                    ]);
                }
            }
        }
    }*/
    protected function afterSave(): void
{
    $appointment = $this->record;

    $selectedTestIds = $this->data['selected_test_ids'] ?? [];
    $priceType = $this->data['price_type'] ?? 'particular';

    // Obtener los tests actuales de la cita
    $currentTestIds = $appointment->appointmentTests()
        ->whereNull('parent_id') // solo padres
        ->pluck('test_id')
        ->toArray();

    // Determinar cuáles agregar y cuáles eliminar
    $testsToAdd = array_diff($selectedTestIds, $currentTestIds);
    $testsToRemove = array_diff($currentTestIds, $selectedTestIds);

    // Eliminar los que ya no están seleccionados
    if (!empty($testsToRemove)) {
        $appointment->appointmentTests()
            ->whereIn('test_id', $testsToRemove)
            ->delete();
    }

    // Agregar los nuevos
    foreach ($testsToAdd as $testId) {
        $test = Test::find($testId);
        if (!$test) continue;

        $price = TestPrice::where('test_id', $test->id)
            ->where('name', $priceType)
            ->value('price') ?? 0;

        $appointmentTest = AppointmentTest::create([
            'appointment_id' => $appointment->id,
            'test_id' => $test->id,
            'parent_id' => null,
            'price' => $price,
        ]);

        // Si es un perfil, agregamos sus hijos
        if ($test->is_profile) {
            $children = Test::where('profile_id', $test->id)->get();

            foreach ($children as $child) {
                $childPrice = TestPrice::where('test_id', $child->id)
                    ->where('name', $priceType)
                    ->value('price') ?? 0;

                AppointmentTest::create([
                    'appointment_id' => $appointment->id,
                    'test_id' => $child->id,
                    'parent_id' => $test->id,
                    'price' => $childPrice,
                ]);
            }
        }
    }
}



    protected function mutateFormDataBeforeFill(array $data): array
    {
        // Asegúrate de que el ID del appointment esté disponible
        $appointmentId = $data['id'] ?? null;

        if ($appointmentId) {
            // Obtiene los test_id principales (no los hijos de perfiles)
            $data['selected_test_ids'] = \App\Models\AppointmentTest::where('appointment_id', $appointmentId)
                ->whereNull('parent_id')
                ->pluck('test_id')
                ->toArray();
        } else {
            $data['selected_test_ids'] = [];
        }

        return $data;
    }
}
