<?php

namespace App\Filament\Resources\AppointmentResource\Pages;

use App\Filament\Resources\AppointmentResource;
use Filament\Actions;
use Filament\Actions\Action;
use Filament\Resources\Pages\ListRecords;
use App\Models\CashRegister;

class ListAppointments extends ListRecords
{
    protected static string $resource = AppointmentResource::class;

    protected function getHeaderActions(): array
    {
        return [
            Action::make('openRegister')
                ->label('Abrir caja')
                ->icon('heroicon-o-banknotes')
                ->form([
                    \Filament\Forms\Components\TextInput::make('opening_amount')
                        ->label('Monto de apertura')
                        ->required()
                        ->numeric()
                        ->prefix('Bs'),
                ])
                ->action(function (array $data): void {
                    CashRegister::create([
                        'user_id' => auth()->id(),
                        'opened_at' => now(),
                        'opening_amount' => $data['opening_amount'],
                        'status' => 'abierto',
                    ]);
                })
                ->visible(function (): bool {
                    return !CashRegister::where('user_id', auth()->id())
                        ->where('status', 'abierto')
                        ->exists();
                })
                ->successNotificationTitle('Caja abierta correctamente'),
            Actions\CreateAction::make()
            ->visible(function (): bool {
                    return CashRegister::where('user_id', auth()->id())
                        ->where('status', 'abierto')
                        ->exists();
                }),
        ];
    }

    
}
