<?php

namespace App\Filament\Resources\AppointmentResource\Pages;

use App\Filament\Resources\AppointmentResource;
use Filament\Actions;
use Filament\Actions\Action;
use Filament\Resources\Pages\ViewRecord;

class ViewAppointment extends ViewRecord
{
    protected static string $resource = AppointmentResource::class;

    protected function getHeaderActions(): array
    {
        return [
            Action::make('Volver')
                ->label('Volver')
                ->url($this->getResource()::getUrl())
                ->icon('heroicon-m-arrow-left'),
        ];
    }

    protected function mutateFormDataBeforeFill(array $data): array
    {
        $appointmentId = $data['id'] ?? null;

        if ($appointmentId) {
            $data['selected_test_ids'] = \App\Models\AppointmentTest::where('appointment_id', $appointmentId)
                ->whereNull('parent_id')
                ->pluck('test_id')
                ->toArray();
        } else {
            $data['selected_test_ids'] = [];
        }

        return $data;
    }
}
