<?php

namespace App\Filament\Resources;

use App\Filament\Resources\CashRegisterResource\Pages;
use App\Filament\Resources\CashRegisterResource\RelationManagers;
use App\Models\CashRegister;
use Filament\Forms;
use Filament\Forms\Form;
use Filament\Resources\Resource;
use Filament\Tables;
use Filament\Tables\Table;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\SoftDeletingScope;

class CashRegisterResource extends Resource
{
    protected static ?string $model = CashRegister::class;
    protected static ?string $modelLabel = 'Caja registradora';
    protected static ?string $pluralModelLabel = 'Caja registradora';
    protected static ?string $navigationGroup = 'Pacientes';
    protected static ?int $navigationSort = 1;


    protected static ?string $navigationIcon = 'heroicon-o-banknotes';

    public static function form(Form $form): Form
    {
        return $form
            ->schema([
                Forms\Components\TextInput::make('opening_amount')
            ]);
    }

    public static function table(Table $table): Table
    {
        return $table
            ->columns([
                Tables\Columns\TextColumn::make('user.full_name')
                    ->label('Usuario')
                    ->numeric()
                    ->sortable(),
                Tables\Columns\TextColumn::make('opened_at')
                    ->label('Abierto')
                    ->dateTime()
                    ->sortable(),
                Tables\Columns\TextColumn::make('closed_at')
                    ->label('Cerrado')
                    ->dateTime()
                    ->sortable(),
                Tables\Columns\TextColumn::make('opening_amount')
                    ->label('Monto de apertura')
                    ->numeric()
                    ->money('BOB', true),
                Tables\Columns\TextColumn::make('closing_amount')
                    ->label('Monto de cierre')
                    ->numeric()
                    ->money('BOB', true),
                Tables\Columns\TextColumn::make('status')
                    ->label('Estado'),

            ])
            ->recordUrl(null)
            ->filters([
                //
            ])
            ->actions([
                //Tables\Actions\EditAction::make(),
            ])
            ->bulkActions([
                /*Tables\Actions\BulkActionGroup::make([
                    Tables\Actions\DeleteBulkAction::make(),
                ]),*/]);
    }

    public static function getRelations(): array
    {
        return [
            //
        ];
    }

    public static function getPages(): array
    {
        return [
            'index' => Pages\ListCashRegisters::route('/'),
            'create' => Pages\CreateCashRegister::route('/create'),
            'edit' => Pages\EditCashRegister::route('/{record}/edit'),
        ];
    }
}
