<?php

namespace App\Filament\Resources;

use App\Filament\Resources\CompanySettingResource\Pages;
use App\Filament\Resources\CompanySettingResource\RelationManagers;
use App\Models\CompanySetting;
use Filament\Forms;
use Filament\Forms\Form;
use Filament\Forms\Components\TextInput;
use Filament\Forms\Components\FileUpload;
use Filament\Forms\Components\TextArea;
use Filament\Forms\Components\Select;
use Filament\Forms\Components\Toggle;
use Filament\Forms\Components\Section;
use Filament\Resources\Resource;
use Filament\Tables;
use Filament\Tables\Columns\ImageColumn;
use Filament\Tables\Table;
use Filament\Tables\Columns\TextColumn;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\SoftDeletingScope;

class CompanySettingResource extends Resource
{
    protected static ?string $model = CompanySetting::class;
    protected static ?string $modelLabel = 'Configuración';
    protected static ?string $pluralModelLabel = 'Configuraciones';
    protected static ?string $navigationGroup = 'Sistema';
    protected static ?string $navigationLabel = 'Configuración';
    protected static ?string $navigationIcon = 'heroicon-o-cog-6-tooth';

    public static function form(Form $form): Form
    {
        return $form
            ->schema([
                TextInput::make('company_name')
                    ->label('Nombre de la Empresa')
                    ->required()
                    ->maxLength(255),
                TextInput::make('company_nit')
                    ->label('NIT de la Empresa')
                    ->required()
                    ->maxLength(50),
                TextInput::make('company_sedes')
                    ->label('Sedes de la Empresa')
                    ->required()
                    ->numeric(),
                    TextInput::make('company_address')
                    ->label('Dirección de la Empresa')
                    ->maxLength(255),
                Section::make([
                    Toggle::make('is_letterhead')
                        ->label('Usar hojas membretadas')
                        ->reactive()
                        ->default(false),
                ]),
                
                TextInput::make('company_phone')
                    ->label('Teléfono de la Empresa')
                    ->tel()
                    ->maxLength(20),
                TextInput::make('company_email')
                    ->label('Correo Electrónico de la Empresa')
                    ->email()
                    ->maxLength(255),
                FileUpload::make('company_logo')
                    ->label('Logo de la Empresa')
                    ->directory('company_logos')
                    ->image(),
                FileUpload::make('company_watermark')
                    ->label('Marca de agua de la Empresa')
                    ->directory('company_watermarks')
                    ->image(),
                
            ]);
    }

    public static function table(Table $table): Table
    {
        return $table
            ->columns([
                TextColumn::make('company_name')
                    ->label('Nombre de la Empresa')
                    ->searchable()
                    ->sortable(),
                ImageColumn::make('company_logo')
                    ->label('Logo de la Empresa'),
                ImageColumn::make('company_watermark')
                    ->label('Marca de Agua'),
                TextColumn::make('company_address')
                    ->label('Dirección de la Empresa')
                    ->searchable()
                    ->sortable(),
                TextColumn::make('company_phone')
                    ->label('Teléfono de la Empresa')
                    ->searchable()
                    ->sortable(),
                TextColumn::make('company_email')
                    ->label('Correo Electrónico de la Empresa')
                    ->searchable()
                    ->sortable(),
                TextColumn::make('company_nit')
                    ->label('NIT de la Empresa')
                    ->searchable()
                    ->sortable(),
                TextColumn::make('company_sedes')
                    ->label('Sedes de la Empresa')
                    ->searchable()
                    ->sortable(),
            ])
            ->filters([
                //
            ])
            ->actions([
                Tables\Actions\EditAction::make(),
            ])
            ->bulkActions([
                Tables\Actions\BulkActionGroup::make([
                    Tables\Actions\DeleteBulkAction::make(),
                ]),
            ]);
    }

    public static function getRelations(): array
    {
        return [
            //
        ];
    }

    public static function getPages(): array
    {
        return [
            'index' => Pages\ListCompanySettings::route('/'),
            'create' => Pages\CreateCompanySetting::route('/create'),
            'edit' => Pages\EditCompanySetting::route('/{record}/edit'),
        ];
    }
}
