<?php

namespace App\Filament\Resources;

use App\Filament\Resources\ComponentResultOptionResource\Pages;
use App\Filament\Resources\ComponentResultOptionResource\RelationManagers;
use App\Models\ComponentResultOption;
use App\Models\TestComponent;
use App\Models\Test;
use Filament\Forms;
use Filament\Forms\Form;
use Filament\Forms\Set;
use Filament\Forms\Get;
use Filament\Forms\Components\Select;
use Filament\Forms\Components\TextInput;
use Filament\Resources\Resource;
use Filament\Tables;
use Filament\Tables\Table;
use Filament\Tables\Filters\SelectFilter;
use Filament\Tables\Columns\TextColumn;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\SoftDeletingScope;
use Filament\Resources\Pages\EditRecord;

class ComponentResultOptionResource extends Resource
{
    protected static ?string $model = ComponentResultOption::class;
    protected static ?string $modelLabel = 'Opción de resultado';
    protected static ?string $pluralModelLabel = 'Opciones de resultado';
    protected static ?int $navigationSort = 4;
    protected static ?string $navigationGroup = 'Laboratorio';
    protected static ?string $navigationLabel = 'Opciones de resultado';

    protected static ?string $navigationIcon = 'heroicon-o-adjustments-horizontal';

    public static function form(Form $form): Form
    {
        return $form
            ->schema([
                Select::make('test_id')
                    ->label('Análisis')
                    ->options(Test::all()->pluck('name', 'id'))
                    ->required()
                    ->reactive()
                    ->afterStateUpdated(fn(Set $set) => $set('component_id', null))
                    ->searchable()
                    ->columnSpanFull()
                    ->disabled(fn($livewire) => $livewire instanceof EditRecord),
                Select::make('component_id')
                    ->label('Componente')
                    ->options(function (Get $get) {
                        if (!$get('test_id')) {
                            return [];
                        }
                        return TestComponent::where('test_id', $get('test_id'))->where('is_group', false)->pluck('name', 'id');
                    })
                    ->required()
                    ->preload(true)
                    ->searchable()
                    ->disabled(fn(Get $get, $livewire) => !$get('test_id') || $livewire instanceof EditRecord)
                    ->reactive()
                    ->columnSpanFull(),
                TextInput::make('result_option')
                    ->label('Opción de resultado')
                    ->required()
                    ->maxLength(255)
                    ->columnSpanFull(),
            ]);
    }

    public static function table(Table $table): Table
    {
        return $table
            ->columns([
                TextColumn::make('component.test.name')
                    ->label('Análisis')
                    ->sortable()
                    ->searchable(),
                TextColumn::make('component.name')
                    ->label('Componente')
                    ->sortable()
                    ->searchable(),
                TextColumn::make('result_option')
                    ->label('Opción de resultado')
                    ->sortable()
                    ->searchable(),
            ])
            ->filters([
                SelectFilter::make('test_id')
                    ->label('Análisis')
                    ->relationship('component.test', 'name')
                    ->searchable()
                    ->preload(),
            ])
            ->actions([
                Tables\Actions\EditAction::make(),
            ])
            ->bulkActions([
                Tables\Actions\BulkActionGroup::make([
                    Tables\Actions\DeleteBulkAction::make(),
                ]),
            ]);
    }

    public static function getRelations(): array
    {
        return [
            //
        ];
    }

    public static function getPages(): array
    {
        return [
            'index' => Pages\ListComponentResultOptions::route('/'),
            'create' => Pages\CreateComponentResultOption::route('/create'),
            'edit' => Pages\EditComponentResultOption::route('/{record}/edit'),
        ];
    }
}
