<?php

namespace App\Filament\Resources\ComponentResultOptionResource\Pages;

use App\Filament\Resources\ComponentResultOptionResource;
use Filament\Actions;
use Filament\Resources\Pages\EditRecord;

class EditComponentResultOption extends EditRecord
{
    protected static string $resource = ComponentResultOptionResource::class;

    protected function getHeaderActions(): array
    {
        return [
            Actions\DeleteAction::make(),
        ];
    }

    protected function mutateFormDataBeforeFill(array $data): array
    {
        // Asegúrate de que 'component' esté cargado
        $component = $this->record->component;

        if ($component) {
            $data['test_id'] = $component->test_id;
        }

        return $data;
    }
}
