<?php

namespace App\Filament\Resources;

use App\Filament\Resources\ComponentResultRangeResource\Pages;
use App\Filament\Resources\ComponentResultRangeResource\RelationManagers;
use App\Models\ComponentResultRange;
use App\Models\Test;
use App\Models\TestComponent;
use Filament\Forms\Set;
use Filament\Forms\Get;
use Dom\Text;
use Filament\Forms;
use Filament\Forms\Components\Group;
use Filament\Forms\Components\Section;
use Filament\Forms\Form;
use Filament\Forms\Components\TextInput;
use Filament\Forms\Components\Select;
use Filament\Resources\Resource;
use Filament\Tables;
use Filament\Tables\Table;
use Filament\Tables\Columns\TextColumn;
use Filament\Tables\Filters\SelectFilter;
use Illuminate\Database\Eloquent\Builder;
use Filament\Resources\Pages\EditRecord;
use Illuminate\Database\Eloquent\SoftDeletingScope;

use function Pest\Laravel\options;

class ComponentResultRangeResource extends Resource
{
    protected static ?string $model = ComponentResultRange::class;
    protected static ?string $modelLabel = 'Rango de Resultados';
    protected static ?string $pluralModelLabel = 'Rangos de Resultados';
    protected static ?string $navigationGroup = 'Laboratorio';
    protected static ?string $navigationLabel = 'Rangos de Resultados';
    protected static ?int $navigationSort = 3;

    protected static ?string $navigationIcon = 'heroicon-o-document-chart-bar';

    public static function form(Form $form): Form
    {
        return $form
            ->schema([
                Select::make('test_id')
                    ->label('Análisis')
                    ->options(Test::all()->pluck('name', 'id'))
                    ->required()
                    ->reactive()
                    ->afterStateUpdated(fn(Set $set) => $set('component_id', null))
                    ->searchable()
                    ->disabled(fn($livewire) => $livewire instanceof EditRecord)
                    ->columnSpanFull(),
                Select::make('component_id')
                    ->label('Componente')
                    ->options(function (Get $get) {
                        if (!$get('test_id')) {
                            return [];
                        }
                        return TestComponent::where('test_id', $get('test_id'))
                            ->where('is_group', false)
                            ->pluck('name', 'id');
                    })
                    ->required()
                    ->searchable()
                    ->disabled(fn(Get $get, $livewire) => !$get('test_id') || $livewire instanceof EditRecord)
                    ->reactive(),
                Select::make('sex')
                    ->label('Sexo')
                    ->options(['Masculino' => 'Masculino', 'Femenino' => 'Femenino','Niños' => 'Niños','Adultos'=>'Adultos','Recien Nacidos'=>'Recien Nacidos']),
                TextInput::make('min_value')
                    ->label('Valor Mínimo')
                    ->required()
                    ->default(0),
                TextInput::make('max_value')
                    ->label('Valor Máximo')
                    ->required()
                    ->default(0),

                Section::make('Rango de edad desde')
                    ->columns(3)
                    ->schema([])->schema([
                        TextInput::make('age_from_years')
                            ->label('Edad (Años)')
                            ->numeric()
                            ->minValue(0)
                            ->default(0),
                        TextInput::make('age_from_months')
                            ->label('Edad (Meses)')
                            ->numeric()
                            ->minValue(0)
                            ->maxValue(11)
                            ->default(0),
                        TextInput::make('age_from_days')
                            ->label('Edad (Días)')
                            ->numeric()
                            ->minValue(0)
                            ->maxValue(30)
                            ->default(0)
                    ])
                    ->columnSpan(1),
                Section::make('Rango de edad hasta')
                    ->columns(3)
                    ->schema([])->schema([

                        TextInput::make('age_to_years')
                            ->label('Edad (Años)')
                            ->numeric()
                            ->minValue(0)
                            ->default(0),
                        TextInput::make('age_to_months')
                            ->label('Edad (Meses)')
                            ->numeric()
                            ->minValue(0)
                            ->maxValue(11)
                            ->default(0),
                        TextInput::make('age_to_days')
                            ->label('Edad (Días)')
                            ->numeric()
                            ->minValue(0)
                            ->maxValue(30)
                            ->default(0)
                    ])
                    ->columnSpan(1),

            ]);
    }

    public static function table(Table $table): Table
    {
        return $table
            ->columns([
                TextColumn::make('component.test.name')
                    ->label('Análisis')
                    ->searchable()
                    ->sortable(),
                TextColumn::make('component.name')
                    ->label('Componente')
                    ->searchable()
                    ->sortable(),
                TextColumn::make('sex')
                    ->label('Sexo')
                    ->sortable(),
                TextColumn::make('age_from_years')
                    ->label('Desde(Años)')
                    ->sortable(),
                TextColumn::make('age_from_months')
                    ->label('Desde(Meses)')
                    ->sortable(),
                TextColumn::make('age_from_days')
                    ->label('Desde(Días)')
                    ->sortable(),
                TextColumn::make('age_to_years')
                    ->label('Hasta(Años)')
                    ->sortable(),
                TextColumn::make('age_to_months')
                    ->label('Hasta(Meses)')
                    ->sortable(),
                TextColumn::make('age_to_days')
                    ->label('Hasta(Días)')
                    ->sortable(),
                TextColumn::make('min_value')
                    ->label('Valor Mínimo')
                    ->sortable()
                    ->numeric(),
                TextColumn::make('max_value')
                    ->label('Valor Máximo')
                    ->sortable()
                    ->numeric(),
            ])
            //->defaultGroup('component.name')
            ->filters([
                SelectFilter::make('test_id')
                    ->label('Análisis')
                    ->relationship('component.test', 'name')
                    ->searchable()
                    ->preload(),
            ])

            ->actions([
                Tables\Actions\EditAction::make(),
            ])
            ->bulkActions([
                Tables\Actions\BulkActionGroup::make([
                    Tables\Actions\DeleteBulkAction::make(),
                ]),
            ]);
    }

    public static function getRelations(): array
    {
        return [
            //
        ];
    }

    public static function getPages(): array
    {
        return [
            'index' => Pages\ListComponentResultRanges::route('/'),
            'create' => Pages\CreateComponentResultRange::route('/create'),
            'edit' => Pages\EditComponentResultRange::route('/{record}/edit'),
        ];
    }
}
