<?php

namespace App\Filament\Resources\PurchaseResource\Pages;

use App\Filament\Resources\PurchaseResource;
use Filament\Actions;
use Filament\Resources\Pages\CreateRecord;
use App\Models\PurchaseProduct;
use App\Models\Inventory;

class CreatePurchase extends CreateRecord
{
    protected static string $resource = PurchaseResource::class;

    protected function mutateFormDataBeforeCreate(array $data): array
    {
        $data['user_id'] = auth()->id();
        unset($data['products']);
        return $data;
    }
    protected function afterCreate(): void
    {
        $productPurchases = $this->form->getState()['products'] ?? [];
        $purchase = $this->record;

        foreach ($productPurchases as $product) {
            $purchaseProduct = $purchase->purchaseProducts()->create([
                'product_presentation_id' => $product['product_presentation_id'],
                'quantity' => $product['quantity'],
                'unit_cost' => $product['unit_cost'],
                'lot_number' => $product['lot_number'],
                'expiration_date' => $product['expiration_date'],
            ]);

            Inventory::create([
                'purchase_product_id' => $purchaseProduct->id,
                'quantity' => $product['quantity'] * $product['presentation'],
                'status' => 'disponible',
            ]);
        }
    }
}
