<?php

namespace App\Filament\Resources\PurchaseResource\Pages;

use App\Filament\Resources\PurchaseResource;
use Filament\Actions;
use App\Models\PurchaseProduct;
use App\Models\Inventory;
use Filament\Resources\Pages\EditRecord;

class EditPurchase extends EditRecord
{
    protected static string $resource = PurchaseResource::class;

    protected function getHeaderActions(): array
    {
        return [
            Actions\DeleteAction::make(),
        ];
    }

    protected function mutateFormDataBeforeSave(array $data): array
    {
        $data['user_id'] = auth()->id();
        unset($data['products']);
        return $data;
    }
    public function afterSave(): void
    {
        $actualIds = [];
        foreach ($this->form->getState()['products'] as $product) {
            if (!empty($product['purchase_product_id'])) {
                $pp = PurchaseProduct::find($product['purchase_product_id']);
                if ($pp) {
                    $pp->update([
                        'quantity' => $product['quantity'],
                        'unit_cost' => $product['unit_cost'],
                        'lot_number' => $product['lot_number'],
                        'expiration_date' => $product['expiration_date'],
                    ]);
                    $actualIds[] = $pp->id;
                    //revisar
                    Inventory::where('purchase_product_id', $product['purchase_product_id'])
                        ->update([
                            'quantity' => $product['quantity'] * $product['presentation'],
                            'status' => 'disponible',
                        ]);
                }
            } else {
                $new = $this->record->purchaseProducts()->create([
                    'product_presentation_id' => $product['product_presentation_id'],
                    'quantity' => $product['quantity'],
                    'unit_cost' => $product['unit_cost'],
                    'lot_number' => $product['lot_number'],
                    'expiration_date' => $product['expiration_date'],
                ]);
                $actualIds[] = $new->id;
                Inventory::create([
                    'purchase_product_id' => $product['purchase_product_id'],
                    'quantity' => $product['quantity'] * $product['presentation'],
                    'status' => 'disponible',
                ]);
            }
        }

        // Eliminar los productos que ya no están en el formulario
        /* $this->record->purchaseProducts()
            ->whereNotIn('id', $actualIds)
            ->delete();*/
    }
}
