<?php
namespace App\Filament\Widgets;

use App\Models\AppointmentTest;
use Filament\Widgets\ChartWidget;
use Illuminate\Support\Facades\DB;

class AppointmentChart extends ChartWidget
{
    protected static ?string $heading = 'Gráfico de Análisis Más Solicitados';
    public ?string $filter = 'today';


    protected function getData(): array
    {
        $startDate = null;
        $endDate = null;

        switch ($this->filter) {
            case 'today':
                $startDate = now()->startOfDay();
                $endDate = now()->endOfDay();
                break;
            case 'week':
                $startDate = now()->subWeek();
                $endDate = now();
                break;
            case 'month':
                $startDate = now()->subMonth();
                $endDate = now();
                break;
            case 'year':
                $startDate = now()->startOfYear();
                $endDate = now();
                break;
        }

        $query = AppointmentTest::select('test_id', DB::raw('count(*) as total'))
            ->whereHas('appointment', function ($query) use ($startDate, $endDate) {
                if ($startDate && $endDate) {
                    $query->whereBetween('appointment_date', [$startDate, $endDate]);
                }
            })
            ->groupBy('test_id')
            ->orderByDesc('total')
            ->with('test')
            ->limit(10);

        $results = $query->get(); 

        return [
            'datasets' => [
                [
                    'label' => 'Cantidad de solicitudes',
                    'data' => $results->pluck('total'),
                    'backgroundColor'=> [
                        'rgba(255, 99, 132, 0.2)',
                        'rgba(255, 159, 64, 0.2)',
                        'rgba(255, 205, 86, 0.2)',
                        'rgba(75, 192, 192, 0.2)',
                        'rgba(54, 162, 235, 0.2)',
                        'rgba(153, 102, 255, 0.2)',
                        'rgba(201, 203, 207, 0.2)'
                      ],
                      'borderColor' =>[
                        'rgb(255, 99, 132)',
                        'rgb(255, 159, 64)',
                        'rgb(255, 205, 86)',
                        'rgb(75, 192, 192)',
                        'rgb(54, 162, 235)',
                        'rgb(153, 102, 255)',
                        'rgb(201, 203, 207)'
                      ],
                      'borderWidth'=> 1
                ],
            ],
            'labels' => $results->pluck('test.name'),
        ];
    }

    protected function getFilters(): ?array
    {
        return [
            'today' => 'Hoy',
            'week' => 'Última semana',
            'month' => 'Último mes',
            'year' => 'Este año',
        ];
    }

    protected function getType(): string
    {
        return 'bar';
    }
}
