<?php

namespace App\Filament\Widgets;

use App\Models\Appointment;
use App\Models\Patient;
use App\Models\User;
use Filament\Widgets\StatsOverviewWidget as BaseWidget;
use Filament\Widgets\StatsOverviewWidget\Stat;

class StatsOverview extends BaseWidget
{
    protected function getColumns(): int
    {
        return 4;
    }

    protected function getStats(): array
    {
        return [
            Stat::make('Usuarios', User::count())
                ->description('Total de usuarios registrados')
                ->icon('heroicon-o-users'),
            Stat::make('Médicos', User::role('Médico')->count())
                ->description('Total de médicos de referencia registrados')
                ->icon('heroicon-o-users'),
            Stat::make('Pacientes', Patient::count())
                ->description('Total de pacientes registrados')
                ->icon('heroicon-o-user-group'),
            Stat::make('Total de ingresos', Appointment::sum('total_cost'))
                ->description('Total de ingresos generados por citas')
                ->color('primary')
                ->icon('heroicon-o-currency-dollar'),
            Stat::make('Total de citas', Appointment::count())
                ->color('primary')
                ->description('Total de citas registradas')
                ->icon('heroicon-o-calendar'),
            Stat::make('Citas pendientes', Appointment::where('status', 'pendiente')->count())
                ->description('Citas que están pendientes de atención')
                ->color('info')
                ->icon('heroicon-o-clock'),
            Stat::make('Citas canceladas', Appointment::where('status', 'cancelado')->count())
                ->description('Citas que han sido canceladas')
                ->color('danger')
                ->icon('heroicon-o-x-circle'),
            Stat::make('Citas completadas', Appointment::where('status', 'completado')->count())
                ->description('Citas que han sido completadas exitosamente')
                ->color('success')
                ->icon('heroicon-o-check-badge'),
            

        ];
    }
}
