<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Appointment extends Model
{
    protected $fillable = [
        'patient_id',
        'doctor_id',
        'user_id',
        'appointment_date',
        'status',
        'notes',
        'price_type',
        'total_cost',
        'paid_amount',
        'balance_due',
    ];

    protected $casts = [
        'appointment_date' => 'datetime',
    ];


    public function patient()
    {
        return $this->belongsTo(Patient::class);
    }

    public function doctor()
    {
        return $this->belongsTo(User::class, 'doctor_id');
    }

    public function user()
    {
        return $this->belongsTo(User::class, 'user_id');
    }
    public function appointmentTests()
    {
        return $this->hasMany(AppointmentTest::class);
    }

    public function testComponentResults()
    {
        return $this->hasManyThrough(
            \App\Models\TestComponentResult::class, // tabla destino (final)
            \App\Models\AppointmentTest::class,     // tabla intermedia
            'appointment_id',                       // FK en appointment_tests → appointments.id
            'appointment_test_id',                  // FK en test_component_results → appointment_tests.id
            'id',                                   // PK en appointments
            'id'                                    // PK en appointment_tests
        );
    }
    public function cashMovements()
    {
        return $this->morphMany(CashMovement::class, 'reference');
    }

    // Resumen para mostrar en tablas
    public function getSummaryAttribute(): string
    {
        return 'Cita #' . $this->id;
    }
    public function observations()
    {
        return $this->hasMany(TestObservation::class);
    }
    
}
