<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class AppointmentTest extends Model
{
    protected $fillable = [
        'appointment_id',
        'test_id',
        'parent_id',
        'price',
    ];

    public function appointment()
    {
        return $this->belongsTo(Appointment::class);
    }

    public function test()
    {
        return $this->belongsTo(Test::class);
    }

    public function parent()
    {
        return $this->belongsTo(AppointmentTest::class, 'parent_id');
    }
    public function children()
    {
        return $this->hasMany(AppointmentTest::class, 'parent_id');
    }

    public function results()
    {
        return $this->hasMany(TestComponentResult::class);
    }
    public function observations()
    {
        // Si usas nombres de clase en observable_type:
        return $this->morphMany(\App\Models\TestObservation::class, 'observable', 'observable_type', 'observable_id');
    }
}
