<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class CashMovement extends Model
{
    protected $fillable = [
        'cash_register_id',
        'user_id',
        'type',
        'method',
        'amount',
        'reference_id',
        'reference_type',
        'note',
    ];

    public function cashRegister()
    {
        return $this->belongsTo(CashRegister::class);
    }

    public function user()
    {
        return $this->belongsTo(User::class);
    }

    public function reference()
    {
        return $this->morphTo();
    }

    // Esto es útil para mostrar resumen en Filament
    public function getReferenceSummaryAttribute(): string
    {
        return method_exists($this->reference, 'summary')
            ? $this->reference->summary
            : class_basename($this->reference_type) . ' #' . $this->reference_id;
    }
}
