<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class ComponentResultRange extends Model
{
    protected $fillable = [
        'component_id',
        'sex',
        'age_from_years',
        'age_from_months',
        'age_from_days',
        'age_to_years',
        'age_to_months',
        'age_to_days',
        'min_value',
        'max_value',
    ];

    public function component()
    {
        return $this->belongsTo(TestComponent::class, 'component_id');
    }
}
