<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Patient extends Model
{
    protected $fillable = [
        'name',
        'last_name',
        'birth_date',
        'age_years',
        'age_months',
        'age_days',
        'sex',
        'address',
        'phone',
        'email',
        'ci',
        'insurance',
    ];
    protected $casts = [
        'birth_date' => 'date',
        'email' => 'string',
    ];
    public function getFullNameAttribute(): string
    {
        return "{$this->name} {$this->last_name}";
    }
}
