<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Product extends Model
{
    protected $fillable = ['name', 'description', 'brand', 'image', 'category_id'];

    public function category()
    {
        return $this->belongsTo(ProductCategory::class, 'category_id');
    }
    public function presentations()
    {
        return $this->hasMany(ProductPresentation::class, 'product_id');
    }

    public function purchaseProducts()
    {
        return $this->hasManyThrough(PurchaseProduct::class, ProductPresentation::class, 'product_id', 'presentation_id');
    }

    public function inventories()
    {
        return $this->hasManyThrough(
            Inventory::class,
            PurchaseProduct::class,
            'presentation_id',        // Foreign key en PurchaseProduct que apunta a PresentationProduct
            'purchase_product_id',    // Foreign key en Inventory que apunta a PurchaseProduct
            'id',                     // Clave primaria en Product
            'id'                      // Clave primaria en PurchaseProduct
        );
    }
}
