<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class ProductPresentation extends Model
{
    protected $fillable = [
        'product_id',
        'unit',
        'quantity',
        'label',
        'barcode',
    ];

    public function product()
    {
        return $this->belongsTo(Product::class, 'product_id');
    }
    public function purchaseProducts()
{
    return $this->hasMany(PurchaseProduct::class, 'presentation_id');
}
}
