<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Purchase extends Model
{
    protected $fillable = [
        'supplier_name',
        'reference_number',
        'date',
        'total_amount',
        'user_id',
    ];

    public function user()
    {
        return $this->belongsTo(User::class);
    }
    public function purchaseProducts()
    {
        return $this->hasMany(PurchaseProduct::class);
    }
}
