<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class PurchaseProduct extends Model
{
    protected $fillable = [
        'purchase_id',
        'product_presentation_id',
        'quantity',
        'unit_cost',
        'lot_number',
        'expiration_date',
    ];

    public function purchase()
    {
        return $this->belongsTo(Purchase::class);
    }

    public function productPresentation()
    {
        return $this->belongsTo(ProductPresentation::class);
    }
    public function inventories()
{
    return $this->hasMany(Inventory::class, 'purchase_product_id');
}
}
