<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class StockMovement extends Model
{
    protected $fillable = [
        'inventory_id',
        'type', // entrada, salida, uso, pérdida, ajuste
        'quantity', // En unidad base
        'unit_used', // Ej: ml, und (opcional para trazabilidad)
        'source_type', // Polimórfico: puede ser PurchaseProduct, Iventory, etc.
        'source_id', // ID del modelo polimórfico
        'observations', // Observaciones adicionales
        'created_by', // Usuario que creó el movimiento
    ];
    public function inventory()
    {
        return $this->belongsTo(Iventory::class);
    }
    public function source()
    {
        return $this->morphTo();
    }
    public function createdBy()
    {
        return $this->belongsTo(User::class, 'created_by');
    }
    
}
