<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Test extends Model
{
    protected $fillable = [
        'name',
        'category_id',
        'is_profile',
        'is_grouped',
        'page_break',
        'is_active',
    ];

    protected $casts = [
        'is_profile' => 'boolean',
    ];
    public function category()
    {
        return $this->belongsTo(TestCategory::class);
    }

    public function prices()
    {
        return $this->hasMany(TestPrice::class);
    }
    public function components()
    {
        return $this->hasMany(TestComponent::class);
    }

    public function profiles() // tests que componen este perfil
    {
        return $this->belongsToMany(Test::class, 'profile_tests', 'profile_id', 'test_id');
    }

    public function includedInProfiles() // perfiles a los que pertenece este test
    {
        return $this->belongsToMany(Test::class, 'profile_tests', 'test_id', 'profile_id');
    }
    
    public function appointmentTests()
{
    return $this->hasMany(AppointmentTest::class);
}
}
