<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class TestComponent extends Model
{
    protected $fillable = [
        'name',
        'test_id',
        'key',
        'unit',
        'result_type',
        'is_group',
        'order',
        'parent_id',
        'is_calculated',
        'calculation_formula',
        'calculation_dependencies',

    ];
    protected $casts = [
        'calculation_dependencies' => 'array',
    ];

    public function test()
    {
        return $this->belongsTo(Test::class);
    }
    public function parent()
    {
        return $this->belongsTo(TestComponent::class, 'parent_id')
            ->where('is_group', true);
    }

    public function resultRanges()
    {
        return $this->hasMany(ComponentResultRange::class, 'component_id');
    }
    public function resultOptions()
    {
        return $this->hasMany(ComponentResultOption::class, 'component_id');
    }
}
