<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class TestComponentResult extends Model
{
    protected $fillable = [
        'appointment_test_id',
        'component_id',
        'input_value',
        'option_value',
        'unit',
        'reference_range',
    ];

    public function appointmentTest()
    {
        return $this->belongsTo(AppointmentTest::class);
    }

    public function component()
    {
        return $this->belongsTo(TestComponent::class);
    }
}
