<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('component_result_ranges', function (Blueprint $table) {
            $table->id();
            $table->foreignId('component_id')->constrained('test_components')->onDelete('cascade');
            $table->string('sex');
            $table->integer('age_from_years')->default(0);
            $table->integer('age_from_months')->default(0);
            $table->integer('age_from_days')->default(0);
            $table->integer('age_to_years')->default(0);
            $table->integer('age_to_months')->default(0);
            $table->integer('age_to_days')->default(0);
            $table->string('min_value')->nullable();
            $table->string('max_value')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('component_result_ranges');
    }
};
