<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('appointment_tests', function (Blueprint $table) {
            $table->id();
            $table->foreignId('appointment_id')->nullable()
                ->constrained('appointments')
                ->onDelete('cascade');
            $table->foreignId('test_id')
                ->constrained('tests')
                ->onDelete('cascade');
             $table->foreignId('parent_id')->nullable()->constrained('appointment_tests')->onDelete('cascade');
             $table->decimal('price', 10, 2);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('appointment_tests');
    }
};
