<x-filament::page>
    <div class="mb-6">
        <h2 class="text-2xl font-bold text-gray-900 dark:text-gray-100">
            Resultados: Cita #{{ $this->appointment->id }}
        </h2>
        <p class="text-sm text-gray-600 dark:text-gray-300">
            Haz clic en una tarjeta para abrir el formulario del test o categoría.
        </p>
    </div>

    <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-4">
        @php $groups = $this->buildGroupsStructure(); @endphp

        @foreach($groups as $key => $g)
            <x-filament::card class="bg-white dark:bg-gray-800">
                <div class="flex items-start justify-between">
                    <div>
                        <h3 class="text-lg font-medium text-gray-900 dark:text-gray-100">{{ $g['label'] }}</h3>
                        <p class="text-sm text-gray-500 dark:text-gray-300 mt-1">
                            {{ count($g['items']) }} componente(s)
                        </p>
                    </div>

                    {{-- Botón Abrir --}}
                    <x-filament::button
                        size="sm"
                        wire:click.prevent="openGroup('{{ $key }}')"
                        class="dark:bg-gray-700  dark:text-gray-100 hover:bg-gray-300 dark:hover:bg-gray-600"
                    >
                        Abrir
                    </x-filament::button>
                </div>
            </x-filament::card>
        @endforeach
    </div>

    <div x-data="{ open: @entangle('showModal') }" x-cloak>
        @if($showModal && $activeGroupKey)
            @php
                $activeGroup = $groups[$activeGroupKey] ?? null;
                $subgroups = [];
                if ($activeGroup) {
                    foreach ($activeGroup['items'] as $it) {
                        $comp = $it['component'];
                        $subName = $comp['group_name'] ?? 'Sin Grupo';
                        $subgroups[$subName][] = $it;
                    }
                }
            @endphp

            <div class="fixed inset-0 z-50 flex items-center justify-center px-4 sm:px-6 lg:px-8" role="dialog" aria-modal="true">
                {{-- Overlay --}}
                <div class="absolute inset-0 bg-black/40" wire:click="closeModal" aria-hidden="true"></div>

                {{-- Modal --}}
                <div class="relative bg-white dark:bg-gray-800 rounded-xl shadow-xl w-full max-w-3xl z-10 flex flex-col h-[90vh]" style="height: 100%">
                    {{-- Header --}}
                    <div class="flex items-center justify-between p-6 border-b border-gray-200 dark:border-gray-700">
                        <h3 class="text-lg font-semibold text-gray-900 dark:text-gray-100">{{ $activeGroup['label'] ?? $activeGroupKey }}</h3>
                        <x-filament::button variant="link" wire:click="closeModal" class="text-sm text-gray-700 dark:text-gray-300">
                            Cerrar
                        </x-filament::button>
                    </div>

                    {{-- Cuerpo con scroll --}}
                    <div class="overflow-y-auto flex-1 p-6 space-y-4">
                        @foreach($subgroups as $subName => $items)
                            <div class="border rounded p-3 bg-gray-50 dark:bg-gray-900 border-gray-200 dark:border-gray-700">
                                <h4 class="font-medium mb-2 text-gray-900 dark:text-gray-100">{{ $subName }}</h4>
                                <div class="grid grid-cols-1 md:grid-cols-3 gap-3">
                                    @foreach($items as $it)
                                        @php 
                                            $index = $it['index']; 
                                            $comp = $it['component']; 
                                        @endphp
                                        <div>
                                            <label class="block text-sm font-medium text-gray-900 dark:text-gray-400 mb-1">
                                                {{ $comp['component_name'] }} ({{ $comp['unit'] ?? '' }})
                                            </label>

                                            @if(!empty($comp['options']))
                                                <select
                                                    wire:model.debounce.500ms="formData.{{ $index }}.option_value"
                                                    class="fi-input block w-full rounded-lg border-gray-300 dark:border-gray-700
                                                           bg-white dark:bg-gray-900 text-gray-900 dark:text-gray-100
                                                           focus:border-primary-500 focus:ring-primary-500"
                                                >
                                                    <option value="">--</option>
                                                    @foreach($comp['options'] as $option)
                                                        <option value="{{ $option }}">{{ $option }}</option>
                                                    @endforeach
                                                </select>
                                            @else
                                                <input
                                                    type="text"
                                                    wire:model.debounce.500ms="formData.{{ $index }}.input_value"
                                                    wire:change="recalcField({{ $index }})"
                                                    class="fi-input block w-full rounded-lg border-gray-300 dark:border-gray-700
                                                           bg-white dark:bg-gray-900 text-gray-900 dark:text-gray-100
                                                           focus:border-primary-500 focus:ring-primary-500"
                                                />
                                            @endif
                                        </div>
                                    @endforeach
                                </div>
                            </div>
                        @endforeach

                        {{-- Observación --}}
                        <div class="mt-4">
                            <label class="block text-sm font-medium text-gray-900 dark:text-gray-400 mb-1">Observación</label>
                            <textarea
                                wire:model.defer="observations.{{ $activeGroupKey }}"
                                rows="4"
                                class="fi-input block w-full rounded-lg border-gray-300 dark:border-gray-700
                                       bg-white dark:bg-gray-900 text-gray-900 dark:text-gray-100
                                       focus:border-primary-500 focus:ring-primary-500"
                            ></textarea>
                        </div>
                    </div>

                    {{-- Footer --}}
                    <div class="flex justify-end gap-3 p-6 border-t border-gray-200 dark:border-gray-700 mt-auto">
                        <x-filament::button wire:click="closeModal" color="gray">Cancelar</x-filament::button>
                        <x-filament::button wire:click="saveGroup">Guardar</x-filament::button>
                    </div>
                </div>
            </div>
        @endif
    </div>
</x-filament::page>
