<!DOCTYPE html>
<html>

<head>
    <meta charset="UTF-8">
    <title>Resultados de Examen</title>

    <style>
        @page {
            margin: {{$companyMarginTop}}px 40px {{$companyMarginBottom}}px 40px;
            /* top, right, bottom, left */
        }

        body {
            font-family: DejaVu Sans, sans-serif;
            font-size: 12px;
        }

        header {
            padding:10px 0;
            position: fixed;
            top: -{{$companyMarginTop}}px;
            left: 0;
            right: 0;
        }

        footer {
            position: fixed;
            bottom: -50px;
            left: 0;
            right: 0;
            font-size: 10px;
            text-align: center;
            border-top: 3px solid black;
        }

        .content-customer {
            position: fixed;
            top: -80px;
            left: 0;
            right: 0;
        }

        table {
            width: 100%;
            border-collapse: collapse;
            line-height:1;
           
        }
        
        .section table {
            width: 100%;
            border-collapse: collapse;
            
        }

        .section th,
        td {
            border: none;
            padding: 0px;
            text-align: left;
            word-wrap: break-word;
            line-height:100%;
            vertical-align:top;
        }
        .section td{
            padding:3px 0;
        }
        .content-customer td {
            border: none;
            padding: 0;
            text-align: left;
            word-wrap: break-word;
            line-height:100%;
        }

        .logo {
            max-height: 85px;
            max-width: 250px;
            width: fit-content;
        }

        .fondo {
            position: fixed;
            top: 45%;
            left: 45%;
            width: fit-content;
            max-width: 300px;
            transform: translateX(-50%) translateY(-50%);
            height: auto;
            max-height: 300px;
            z-index: -1;
            opacity: 0.1;
            /* Ajusta la opacidad según sea necesario */
        }
        /* Evita que el bloque se corte entre páginas */
        .test-block,
        .category-block,
        .group-block {
        page-break-inside: avoid;   /* compat con motores antiguos */
        break-inside: avoid;        /* estándar moderno */
        -webkit-column-break-inside: avoid;
        -moz-column-break-inside: avoid;
        }

        /* Forzar que los títulos no queden solos al final (mantener con lo siguiente) */
        .keep-with-next {
        page-break-after: avoid;
        break-after: avoid;
        }

        /* Repetir encabezado de tabla al saltar de página */
        thead { display: table-header-group; }
        tfoot { display: table-footer-group; }

        /* Clase para insertar salto de página manual */
        .page-break { page-break-before: always; break-before: page; }
        .sello {
            position: fixed;
            bottom: 0;
            left: 45%;
            width: fit-content;
            max-width: 200px;
            transform: translateX(-50%);
            height: auto;
            max-height: 100px;
            z-index: -1;
        }
    </style>
</head>

<body>
    @if ($companyIsLetterhead == 0)
    <img class="fondo" src="{{ public_path('storage/'.$companyWatermark) }}" alt="Fondo">
    @endif
    <!--<img class="sello" src="{{ public_path('storage/'.$record->user->signature) }}" alt="Sello">-->
    {{-- Header que se repite en cada hoja --}}
    <header>
        @if ($companyIsLetterhead == 0)
        <table>
            <tr>
                <td style="width: 70%;">
                    <img class="logo" src="{{ public_path('storage/'.$companyLogo) }}" alt="Logo">
                </td>
                <td>
                    <p><strong>NIT:</strong> {{ $companyNit }}</p>
                    <p><strong>SEDES:</strong> {{ $companySedes }}</p>
                </td>
            </tr>
        </table>
        @endif
    </header>

    {{-- Footer que se repite en cada hoja --}}
    @if ($companyIsLetterhead == 0)
    <footer>
        <table>
            <tr>
                <td><strong>Dirección:</strong> {{$companyAddress}}</td>
                <td><strong>Teléfono:</strong> {{$companyPhone}}</td>
            </tr>
        </table>
    </footer>
    @endif
    <div class="content-customer">
        <div style="border: 2px solid black; border-radius: 10px;padding:3px">
            @php
            $age = '';
            if ($record->patient->age_years > 0) {
            $age = $record->patient->age_years . ' Años';
            if ($record->patient->age_months > 0) {
            $age .= ' y ' . $record->patient->age_months . ' Meses';
            }
            } elseif ($record->patient->age_months > 0) {
            $age = $record->patient->age_months . ' meses';
            if ($record->patient->age_days > 0) {
            $age .= ' y ' . $record->patient->age_days . ' Días';
            }
            } elseif ($record->patient->age_days > 0) {
            $age = $record->patient->age_days . ' Días';
            } else {
            $age = 'No especificada';
            }
            @endphp

            <table>
                <tr>
                    <td><strong>Paciente:</strong> {{ $record->patient->name }} {{ $record->patient->last_name }}</td>
                    <td></td>
                    <td><strong>Edad:</strong> {{$age}}</td>
                </tr>
                <tr>
                    <td><strong>Médico:</strong> {{ $record->doctor->name }} {{ $record->doctor->last_name }}</td>
                    <td></td>
                    <td><strong>Sexo:</strong> {{ $record->patient->sex }}</td>
                </tr>
                <tr>
                    <td><strong>Código:</strong> {{ $record->id }}</td>
                    <td></td>
                    <td><strong>Fecha:</strong> {{ $record->appointment_date }}</td>
                </tr>
            </table>
        </div>
        <table style="margin-top: 5px;border-collapse: collapse; width: 100%;">
            <thead>
                <tr>
                    <th style="width:30%; border:1px solid black;">Análisis</th>
                    <th style="width:30%; border:1px solid black;">Resultado</th>
                    <th style="width:40%; border:1px solid black;">Valor de referencia</th>
                </tr>
            </thead>
        </table>
    </div>
    {{-- Contenido principal --}}
    @php
    // Cargar relaciones necesarias (observations incluida)
    $results = $record->testComponentResults->load(['component.parent', 'component.test.category']);
    $observations = $record->observations ?? collect();

    // Agrupar en 2 niveles:
    // - Primero: tests que van agrupados, organizados por categoría (guardamos id|name)
    $groupedByCategory = $results->filter(fn($r) => $r->component->test->is_grouped)
    ->groupBy(fn($r) => ($r->component->test->category->id ?? 'null') . '|' . ($r->component->test->category->name ?? 'Sin categoría'));

    // - Tests no agrupados por test id
    $ungroupedByTest = $results->filter(fn($r) => !$r->component->test->is_grouped)
    ->groupBy(fn($r) => $r->component->test->id);
    @endphp

    <div class="section">

        {{-- Mostrar agrupados por categoría --}}
        @php $firstPageBreak = true; @endphp
        @foreach ($groupedByCategory as $categoryKey => $categoryResults)
        @php
        // extraer id y nombre desde la key "id|name"
        [$categoryId, $categoryName] = explode('|', $categoryKey, 2);
        $categoryId = $categoryId === 'null' ? null : (int) $categoryId;

        $needsPageBreak = $categoryResults->first()->component->test->page_break ?? false;

        // Dentro de la categoría, los agrupamos por "parent" (subgrupos)
        $groupedResults = $categoryResults->groupBy(fn($r) => $r->component->parent?->name ?? '');

        // buscar observación asociada a esta categoría (soporta ambos nombres de columna)
        $obs = $observations->first(function($o) use ($categoryId) {
        return ($o->observable_type === 'category' || $o->observable_type === \App\Models\TestCategory::class)
        && $o->observable_id == $categoryId;
        });
        $obsText = $obs->observation_text ?? $obs->observation ?? '';
        @endphp
        @if (!$firstPageBreak)
        <div class="page-break"></div>
        @endif
        @php $firstPageBreak = false; @endphp
        <div class="">
        <h3 style="text-align: center; margin-top:0px; margin-bottom:0px;">
            {{ $categoryName }}
        </h3>

        @foreach ($groupedResults as $groupName => $groupResults)
        @if ($groupName)
        <strong>{{ $groupName }}</strong>
        @endif
        <table>
            <tbody>
                @foreach ($groupResults->sortBy(fn($r) => $r->component->order ?? 0) as $result)
                <tr>
                    <td style="width: 30%;">{{ $result->component->name }}</td>
                    <td style="width: 30%;font-weight:bold;">
                        @php
                        $rawValue = $result->input_value ?: $result->option_value;
                        /*if (is_numeric($rawValue)) {
                        $value = (float) $rawValue;
                        $formatted = ($value != (int) $value)
                        ? number_format($value, 2, ',', '.')
                        : number_format($value, 0, '', '.');
                        } else {*/
                        $formatted = $rawValue;
                        //}
                        @endphp
                        {{ $formatted }} {{ $result->unit }}
                    </td>
                    <td style="width: 40%;font-size:11px">
                        @foreach ($result->component->resultRanges as $range)
                        <div>
                            {{ $range->sex ?? '' }}
                            @if ($range->age_from_years !== null && $range->age_to_years !== null && $range->age_to_years>0)
                            De {{ $range->age_from_years }} - {{ $range->age_to_years }} años
                            @elseif ($range->age_from_months !== null && $range->age_to_months !== null && $range->age_to_months >0)
                            De {{ $range->age_from_months }} - {{ $range->age_to_months }} meses
                            @elseif ($range->age_from_days !== null && $range->age_to_days !== null && $range->age_to_days>0)
                            De {{ $range->age_from_days }} - {{ $range->age_to_days }} días
                            @endif

                            @php
                            $min = $range->min_value;
                            $max = $range->max_value;

                            /*if (is_numeric($min)) {
                            $min = (float) $min;
                            $min = ($min != (int) $min)
                            ? number_format($min, 2, ',', '.')
                            : number_format($min, 0, '', '.');
                            }
                            if (is_numeric($max)) {
                            $max = (float) $max;
                            $max = ($max != (int) $max)
                            ? number_format($max, 2, ',', '.')
                            : number_format($max, 0, '', '.');
                            }*/
                            @endphp

                            {{ $min }} - {{ $max }} {{ $result->unit }}
                        </div>
                        @endforeach
                    </td>
                </tr>
                @endforeach
            </tbody>
        </table>
        @endforeach

        {{-- Mostrar observación de la categoría (si existe) --}}
        @if (!empty(trim((string)$obsText)))
        <div style="margin-top:8px; padding:8px; border:1px solid #333; border-radius:6px;">
            <strong>Observación:</strong>
            <div style="white-space:pre-wrap; margin-top:6px;">{{ $obsText }}</div>
        </div>
        @endif
        </div>
        @endforeach

        {{-- Mostrar tests no agrupados --}}
        @php
        // Agrupar tests no agrupados por appointment_test_id (id del pedido en la cita)
        $ungroupedByApptTest = $results->filter(fn($r) => !$r->component->test->is_grouped)
        ->groupBy(fn($r) => $r->appointment_test_id);
        
        @endphp

        {{-- Mostrar tests no agrupados --}}

        @foreach ($ungroupedByApptTest as $apptTestId => $results)
        @php
       
        // tomar el objeto appointment_test (info de test a mostrar)
        $first = $results->first();
        $test = $first->component->test;
        $needsPageBreak = $test->page_break ?? false;
        
        $groupedResults = $results->groupBy(fn($r) => $r->component->parent?->name ?? '');

        // buscar observación por appointment_test id
        $obs = $observations->first(function($o) use ($apptTestId) {
        return ($o->observable_type === 'test' || $o->observable_type === \App\Models\AppointmentTest::class)
        && $o->observable_id == $apptTestId;
        });
        $obsText = $obs->observation_text ?? $obs->observation ?? '';
        @endphp

        @if (!$firstPageBreak && $needsPageBreak)
        <div class="page-break"></div>
        @endif

        <h3 style="text-align: center; margin-top:0px; margin-bottom:0px;">
            {{ $test->name }}
        </h3>

        @foreach ($groupedResults as $groupName => $groupResults)
        @if ($groupName)
        <strong>{{ $groupName }}</strong>
        @endif
        <table>
            <tbody>
                @foreach ($groupResults->sortBy(fn($r) => $r->component->order ?? 0) as $result)
                @php
                $input = isset($result->input_value) ? trim((string) $result->input_value) : '';
                $option = isset($result->option_value) ? trim((string) $result->option_value) : '';
                @endphp

                @if ($input !== '' || $option !== '')
                <tr>
                    <td style="width: 30%;">{{ $result->component->name }}</td>
                    <td style="width: 30%;font-weight:bold;">@php
                        $rawValue = $result->input_value ?: $result->option_value;
                       /* if (is_numeric($rawValue)) {
                        $value = (float) $rawValue;
                        $formatted = ($value != (int) $value)
                        ? number_format($value, 2, ',', '.')
                        : number_format($value, 0, '', '.');
                        } else {*/
                        $formatted = $rawValue;
                        //}
                        @endphp
                        {{ $formatted }} {{ $result->unit }}</td>
                    <td style="width: 40%;font-size:11px">
                        @foreach ($result->component->resultRanges as $range)
                        <div>
                            {{ $range->sex ?? '' }}
                            @if ($range->age_from_years !== null && $range->age_to_years !== null && $range->age_to_years>0)
                            De {{ $range->age_from_years }} - {{ $range->age_to_years }} años
                            @elseif ($range->age_from_months !== null && $range->age_to_months !== null && $range->age_to_months>0)
                            De {{ $range->age_from_months }} - {{ $range->age_to_months }} meses
                            @elseif ($range->age_from_days !== null && $range->age_to_days !== null && $range->age_to_days>0)
                            De {{ $range->age_from_days }} - {{ $range->age_to_days }} días
                            @endif

                            @php
                            $min = $range->min_value;
                            $max = $range->max_value;

                           /* if (is_numeric($min)) {
                            $min = (float) $min;
                            $min = ($min != (int) $min)
                            ? number_format($min, 2, ',', '.')
                            : number_format($min, 0, '', '.');
                            }
                            if (is_numeric($max)) {
                            $max = (float) $max;
                            $max = ($max != (int) $max)
                            ? number_format($max, 2, ',', '.')
                            : number_format($max, 0, '', '.');
                            }*/
                            @endphp

                            {{ $min }} - {{ $max }} {{ $result->unit }}
                        </div>
                        @endforeach
                    </td>
                </tr>
                @endif
                @endforeach
            </tbody>
        </table>
        @endforeach

        {{-- Mostrar observación del test (si existe) --}}
        @if (!empty(trim((string)$obsText)))
        <div style="margin-top:8px; padding:8px; border:1px solid #333; border-radius:6px;">
            <strong>Observación:</strong>
            <div style="white-space:pre-wrap; margin-top:6px;">{{ $obsText }}</div>
        </div>
        @endif
        @endforeach
    </div>



</body>

</html>