<?php

use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Route;
use Barryvdh\DomPDF\Facade\Pdf;
use App\Models\Appointment;
use App\Models\CompanySetting;



Route::get('/', function () {
    return view('welcome');
});
Route::get('/appointments/{appointment}/export-pdf', function (Appointment $appointment) {
    $company = CompanySetting::first();

    $appointment->load([
        'patient',
        'user',
        'testComponentResults.component.test', // importante para agrupar
    ]);

    return Pdf::loadView('pdf.appointment', [
        'record' => $appointment,
        'companyName' => $company->company_name ?? 'Nombre Empresa',
        'companyNit' => $company->company_nit ?? 'NIT',
        'companySedes'=>$company->company_sedes ?? 'NIT',
        'companyLogo'=>$company->company_logo,
        'companyWatermark'=>$company->company_watermark,
        'companyAddress'=>$company->company_address,
        'companyPhone'=>$company->company_phone,
        'companyIsLetterhead'=>$company->is_letterhead,
        'companyMarginTop'=>$company->is_letterhead==1?180:180,
        'companyMarginBottom'=>$company->is_letterhead==1?70:70,
    ])->stream("appointment-{$appointment->id}.pdf");
})->name('appointments.export.pdf');
