<!DOCTYPE html>
<html>

<head>
    <meta charset="UTF-8">
    <title>Resultados de Examen</title>

    <style>
        @page {
            margin: <?php echo e($companyMarginTop); ?>px 40px <?php echo e($companyMarginBottom); ?>px 40px;
            /* top, right, bottom, left */
        }

        body {
            font-family: DejaVu Sans, sans-serif;
            font-size: 12px;
        }

        header {
            padding:10px 0;
            position: fixed;
            top: -<?php echo e($companyMarginTop); ?>px;
            left: 0;
            right: 0;
        }

        footer {
            position: fixed;
            bottom: -50px;
            left: 0;
            right: 0;
            font-size: 10px;
            text-align: center;
            border-top: 3px solid black;
        }

        .content-customer {
            position: fixed;
            top: -80px;
            left: 0;
            right: 0;
        }

        table {
            width: 100%;
            border-collapse: collapse;
            line-height:1;
           
        }
        
        .section table {
            width: 100%;
            border-collapse: collapse;
            
        }

        .section th,
        td {
            border: none;
            padding: 0px;
            text-align: left;
            word-wrap: break-word;
            line-height:100%;
            vertical-align:top;
        }
        .section td{
            padding:3px 0;
        }
        .content-customer td {
            border: none;
            padding: 0;
            text-align: left;
            word-wrap: break-word;
            line-height:100%;
        }

        .logo {
            max-height: 85px;
            max-width: 250px;
            width: fit-content;
        }

        .fondo {
            position: fixed;
            top: 45%;
            left: 45%;
            width: fit-content;
            max-width: 300px;
            transform: translateX(-50%) translateY(-50%);
            height: auto;
            max-height: 300px;
            z-index: -1;
            opacity: 0.1;
            /* Ajusta la opacidad según sea necesario */
        }
        /* Evita que el bloque se corte entre páginas */
        .test-block,
        .category-block,
        .group-block {
        page-break-inside: avoid;   /* compat con motores antiguos */
        break-inside: avoid;        /* estándar moderno */
        -webkit-column-break-inside: avoid;
        -moz-column-break-inside: avoid;
        }

        /* Forzar que los títulos no queden solos al final (mantener con lo siguiente) */
        .keep-with-next {
        page-break-after: avoid;
        break-after: avoid;
        }

        /* Repetir encabezado de tabla al saltar de página */
        thead { display: table-header-group; }
        tfoot { display: table-footer-group; }

        /* Clase para insertar salto de página manual */
        .page-break { page-break-before: always; break-before: page; }
        .sello {
            position: fixed;
            bottom: 0;
            left: 45%;
            width: fit-content;
            max-width: 200px;
            transform: translateX(-50%);
            height: auto;
            max-height: 100px;
            z-index: -1;
        }
    </style>
</head>

<body>
    <?php if($companyIsLetterhead == 0): ?>
    <img class="fondo" src="<?php echo e(public_path('storage/'.$companyWatermark)); ?>" alt="Fondo">
    <?php endif; ?>
    <!--<img class="sello" src="<?php echo e(public_path('storage/'.$record->user->signature)); ?>" alt="Sello">-->
    
    <header>
        <?php if($companyIsLetterhead == 0): ?>
        <table>
            <tr>
                <td style="width: 70%;">
                    <img class="logo" src="<?php echo e(public_path('storage/'.$companyLogo)); ?>" alt="Logo">
                </td>
                <td>
                    <p><strong>NIT:</strong> <?php echo e($companyNit); ?></p>
                    <p><strong>SEDES:</strong> <?php echo e($companySedes); ?></p>
                </td>
            </tr>
        </table>
        <?php endif; ?>
    </header>

    
    <?php if($companyIsLetterhead == 0): ?>
    <footer>
        <table>
            <tr>
                <td><strong>Dirección:</strong> <?php echo e($companyAddress); ?></td>
                <td><strong>Teléfono:</strong> <?php echo e($companyPhone); ?></td>
            </tr>
        </table>
    </footer>
    <?php endif; ?>
    <div class="content-customer">
        <div style="border: 2px solid black; border-radius: 10px;padding:3px">
            <?php
            $age = '';
            if ($record->patient->age_years > 0) {
            $age = $record->patient->age_years . ' Años';
            if ($record->patient->age_months > 0) {
            $age .= ' y ' . $record->patient->age_months . ' Meses';
            }
            } elseif ($record->patient->age_months > 0) {
            $age = $record->patient->age_months . ' meses';
            if ($record->patient->age_days > 0) {
            $age .= ' y ' . $record->patient->age_days . ' Días';
            }
            } elseif ($record->patient->age_days > 0) {
            $age = $record->patient->age_days . ' Días';
            } else {
            $age = 'No especificada';
            }
            ?>

            <table>
                <tr>
                    <td><strong>Paciente:</strong> <?php echo e($record->patient->name); ?> <?php echo e($record->patient->last_name); ?></td>
                    <td></td>
                    <td><strong>Edad:</strong> <?php echo e($age); ?></td>
                </tr>
                <tr>
                    <td><strong>Médico:</strong> <?php echo e($record->doctor->name); ?> <?php echo e($record->doctor->last_name); ?></td>
                    <td></td>
                    <td><strong>Sexo:</strong> <?php echo e($record->patient->sex); ?></td>
                </tr>
                <tr>
                    <td><strong>Código:</strong> <?php echo e($record->id); ?></td>
                    <td></td>
                    <td><strong>Fecha:</strong> <?php echo e($record->appointment_date); ?></td>
                </tr>
            </table>
        </div>
        <table style="margin-top: 5px;border-collapse: collapse; width: 100%;">
            <thead>
                <tr>
                    <th style="width:30%; border:1px solid black;">Análisis</th>
                    <th style="width:30%; border:1px solid black;">Resultado</th>
                    <th style="width:40%; border:1px solid black;">Valor de referencia</th>
                </tr>
            </thead>
        </table>
    </div>
    
    <?php
    // Cargar relaciones necesarias (observations incluida)
    $results = $record->testComponentResults->load(['component.parent', 'component.test.category']);
    $observations = $record->observations ?? collect();

    // Agrupar en 2 niveles:
    // - Primero: tests que van agrupados, organizados por categoría (guardamos id|name)
    $groupedByCategory = $results->filter(fn($r) => $r->component->test->is_grouped)
    ->groupBy(fn($r) => ($r->component->test->category->id ?? 'null') . '|' . ($r->component->test->category->name ?? 'Sin categoría'));

    // - Tests no agrupados por test id
    $ungroupedByTest = $results->filter(fn($r) => !$r->component->test->is_grouped)
    ->groupBy(fn($r) => $r->component->test->id);
    ?>

    <div class="section">

        
        <?php $firstPageBreak = true; ?>
        <?php $__currentLoopData = $groupedByCategory; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $categoryKey => $categoryResults): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <?php
        // extraer id y nombre desde la key "id|name"
        [$categoryId, $categoryName] = explode('|', $categoryKey, 2);
        $categoryId = $categoryId === 'null' ? null : (int) $categoryId;

        $needsPageBreak = $categoryResults->first()->component->test->page_break ?? false;

        // Dentro de la categoría, los agrupamos por "parent" (subgrupos)
        $groupedResults = $categoryResults->groupBy(fn($r) => $r->component->parent?->name ?? '');

        // buscar observación asociada a esta categoría (soporta ambos nombres de columna)
        $obs = $observations->first(function($o) use ($categoryId) {
        return ($o->observable_type === 'category' || $o->observable_type === \App\Models\TestCategory::class)
        && $o->observable_id == $categoryId;
        });
        $obsText = $obs->observation_text ?? $obs->observation ?? '';
        ?>
        <?php if(!$firstPageBreak): ?>
        <div class="page-break"></div>
        <?php endif; ?>
        <?php $firstPageBreak = false; ?>
        <div class="">
        <h3 style="text-align: center; margin-top:0px; margin-bottom:0px;">
            <?php echo e($categoryName); ?>

        </h3>

        <?php $__currentLoopData = $groupedResults; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $groupName => $groupResults): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <?php if($groupName): ?>
        <strong><?php echo e($groupName); ?></strong>
        <?php endif; ?>
        <table>
            <tbody>
                <?php $__currentLoopData = $groupResults->sortBy(fn($r) => $r->component->order ?? 0); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $result): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr>
                    <td style="width: 30%;"><?php echo e($result->component->name); ?></td>
                    <td style="width: 30%;font-weight:bold;">
                        <?php
                        $rawValue = $result->input_value ?: $result->option_value;
                        /*if (is_numeric($rawValue)) {
                        $value = (float) $rawValue;
                        $formatted = ($value != (int) $value)
                        ? number_format($value, 2, ',', '.')
                        : number_format($value, 0, '', '.');
                        } else {*/
                        $formatted = $rawValue;
                        //}
                        ?>
                        <?php echo e($formatted); ?> <?php echo e($result->unit); ?>

                    </td>
                    <td style="width: 40%;font-size:11px">
                        <?php $__currentLoopData = $result->component->resultRanges; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $range): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div>
                            <?php echo e($range->sex ?? ''); ?>

                            <?php if($range->age_from_years !== null && $range->age_to_years !== null && $range->age_to_years>0): ?>
                            De <?php echo e($range->age_from_years); ?> - <?php echo e($range->age_to_years); ?> años
                            <?php elseif($range->age_from_months !== null && $range->age_to_months !== null && $range->age_to_months >0): ?>
                            De <?php echo e($range->age_from_months); ?> - <?php echo e($range->age_to_months); ?> meses
                            <?php elseif($range->age_from_days !== null && $range->age_to_days !== null && $range->age_to_days>0): ?>
                            De <?php echo e($range->age_from_days); ?> - <?php echo e($range->age_to_days); ?> días
                            <?php endif; ?>

                            <?php
                            $min = $range->min_value;
                            $max = $range->max_value;

                            /*if (is_numeric($min)) {
                            $min = (float) $min;
                            $min = ($min != (int) $min)
                            ? number_format($min, 2, ',', '.')
                            : number_format($min, 0, '', '.');
                            }
                            if (is_numeric($max)) {
                            $max = (float) $max;
                            $max = ($max != (int) $max)
                            ? number_format($max, 2, ',', '.')
                            : number_format($max, 0, '', '.');
                            }*/
                            ?>

                            <?php echo e($min); ?> - <?php echo e($max); ?> <?php echo e($result->unit); ?>

                        </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </td>
                </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tbody>
        </table>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

        
        <?php if(!empty(trim((string)$obsText))): ?>
        <div style="margin-top:8px; padding:8px; border:1px solid #333; border-radius:6px;">
            <strong>Observación:</strong>
            <div style="white-space:pre-wrap; margin-top:6px;"><?php echo e($obsText); ?></div>
        </div>
        <?php endif; ?>
        </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

        
        <?php
        // Agrupar tests no agrupados por appointment_test_id (id del pedido en la cita)
        $ungroupedByApptTest = $results->filter(fn($r) => !$r->component->test->is_grouped)
        ->groupBy(fn($r) => $r->appointment_test_id);
        
        ?>

        

        <?php $__currentLoopData = $ungroupedByApptTest; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $apptTestId => $results): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <?php
       
        // tomar el objeto appointment_test (info de test a mostrar)
        $first = $results->first();
        $test = $first->component->test;
        $needsPageBreak = $test->page_break ?? false;
        
        $groupedResults = $results->groupBy(fn($r) => $r->component->parent?->name ?? '');

        // buscar observación por appointment_test id
        $obs = $observations->first(function($o) use ($apptTestId) {
        return ($o->observable_type === 'test' || $o->observable_type === \App\Models\AppointmentTest::class)
        && $o->observable_id == $apptTestId;
        });
        $obsText = $obs->observation_text ?? $obs->observation ?? '';
        ?>

        <?php if(!$firstPageBreak && $needsPageBreak): ?>
        <div class="page-break"></div>
        <?php endif; ?>

        <h3 style="text-align: center; margin-top:0px; margin-bottom:0px;">
            <?php echo e($test->name); ?>

        </h3>

        <?php $__currentLoopData = $groupedResults; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $groupName => $groupResults): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <?php if($groupName): ?>
        <strong><?php echo e($groupName); ?></strong>
        <?php endif; ?>
        <table>
            <tbody>
                <?php $__currentLoopData = $groupResults->sortBy(fn($r) => $r->component->order ?? 0); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $result): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <?php
                $input = isset($result->input_value) ? trim((string) $result->input_value) : '';
                $option = isset($result->option_value) ? trim((string) $result->option_value) : '';
                ?>

                <?php if($input !== '' || $option !== ''): ?>
                <tr>
                    <td style="width: 30%;"><?php echo e($result->component->name); ?></td>
                    <td style="width: 30%;font-weight:bold;"><?php
                        $rawValue = $result->input_value ?: $result->option_value;
                       /* if (is_numeric($rawValue)) {
                        $value = (float) $rawValue;
                        $formatted = ($value != (int) $value)
                        ? number_format($value, 2, ',', '.')
                        : number_format($value, 0, '', '.');
                        } else {*/
                        $formatted = $rawValue;
                        //}
                        ?>
                        <?php echo e($formatted); ?> <?php echo e($result->unit); ?></td>
                    <td style="width: 40%;font-size:11px">
                        <?php $__currentLoopData = $result->component->resultRanges; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $range): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div>
                            <?php echo e($range->sex ?? ''); ?>

                            <?php if($range->age_from_years !== null && $range->age_to_years !== null && $range->age_to_years>0): ?>
                            De <?php echo e($range->age_from_years); ?> - <?php echo e($range->age_to_years); ?> años
                            <?php elseif($range->age_from_months !== null && $range->age_to_months !== null && $range->age_to_months>0): ?>
                            De <?php echo e($range->age_from_months); ?> - <?php echo e($range->age_to_months); ?> meses
                            <?php elseif($range->age_from_days !== null && $range->age_to_days !== null && $range->age_to_days>0): ?>
                            De <?php echo e($range->age_from_days); ?> - <?php echo e($range->age_to_days); ?> días
                            <?php endif; ?>

                            <?php
                            $min = $range->min_value;
                            $max = $range->max_value;

                           /* if (is_numeric($min)) {
                            $min = (float) $min;
                            $min = ($min != (int) $min)
                            ? number_format($min, 2, ',', '.')
                            : number_format($min, 0, '', '.');
                            }
                            if (is_numeric($max)) {
                            $max = (float) $max;
                            $max = ($max != (int) $max)
                            ? number_format($max, 2, ',', '.')
                            : number_format($max, 0, '', '.');
                            }*/
                            ?>

                            <?php echo e($min); ?> - <?php echo e($max); ?> <?php echo e($result->unit); ?>

                        </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </td>
                </tr>
                <?php endif; ?>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tbody>
        </table>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

        
        <?php if(!empty(trim((string)$obsText))): ?>
        <div style="margin-top:8px; padding:8px; border:1px solid #333; border-radius:6px;">
            <strong>Observación:</strong>
            <div style="white-space:pre-wrap; margin-top:6px;"><?php echo e($obsText); ?></div>
        </div>
        <?php endif; ?>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </div>



</body>

</html><?php /**PATH /home/namesystem/laboratory.name-system.com/resources/views/pdf/appointment.blade.php ENDPATH**/ ?>