<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('test_components', function (Blueprint $table) {
            $table->id();
            $table->foreignId('test_id')
                ->constrained('tests')
                ->onDelete('cascade');
            $table->string('name');
            $table->string('key')->unique()
                ->comment('Clave única del componente, utilizada para cálculos y referencias');
            $table->string('unit')->nullable();
            $table->enum('result_type', ['text', 'number', 'select'])->nullable();
            $table->boolean('is_group')->default(false);
            $table->integer('order')->nullable()->default(0);
            $table->integer('parent_id')
                ->nullable()
                ->comment('ID del componente grupo o titulo');
            $table->boolean('is_calculated')->default(false);
            $table->json('calculation_dependencies')->nullable(); // array de claves
            $table->text('calculation_formula')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('test_components');
    }
};
