<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('test_component_results', function (Blueprint $table) {
            $table->id();
            $table->foreignId('appointment_test_id')->constrained('appointment_tests')->onDelete('cascade');
            $table->foreignId('component_id')->constrained('test_components')->onDelete('cascade');
            $table->string('input_value')->nullable();
            $table->string('option_value')->nullable();
            $table->string('unit')->nullable();
            $table->string('reference_range')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('test_component_results');
    }
};
