<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('inventories', function (Blueprint $table) {
            $table->id();
            $table->foreignId('purchase_product_id')->constrained('purchase_products')->cascadeOnDelete();
            $table->decimal('quantity', 10, 2); // En unidad base (ej. ml, und)
            $table->enum('status', ['disponible', 'vencido', 'proximo_a_vencer', 'agotado', 'bloqueado'])->default('disponible');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('inventories');
    }
};
